local mStages = STATSMAN:GetStagesPlayed();
local i = 0;
local grades = {
	Grade_Tier01 = 0;
	Grade_Tier02 = 1;
	Grade_Tier03 = 2;
	Grade_Tier04 = 3;
	Grade_Tier05 = 4;
	Grade_Tier06 = 5;
	Grade_Tier07 = 6;
	Grade_Failed = 7;
	Grade_None = nil;
};

local DifficultyToFrame = {
	Difficulty_Beginner	= 0;
	Difficulty_Easy		= 1;
	Difficulty_Medium		= 2;
	Difficulty_Hard		= 3;
	Difficulty_Challenge	= 4;
	Difficulty_Edit		= 5;
	Difficulty_None		= nil;
};

local t = Def.ActorFrame {};  

for i = 1, mStages do
	local ssStats = STATSMAN:GetPlayedStageStats( i );
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(Center;);
		BeginCommand=function(self)
			if mStages == 2 then
				self:addy(40 + ((mStages - i) * 50) - 52);
			elseif mStages == 4 then
				self:addy(-10 + ((mStages - i) * 50) - 52);
			elseif mStages == 5 then
				self:addy(-30 + ((mStages - i) * 50) - 52);
			elseif mStages == 6 then
				self:addy(-50 + ((mStages - i) * 50) - 52);
			elseif mStages == 7 then
				self:addy(-70 + ((mStages - i) * 50) - 52);
			else
				self:addy(((mStages - i) * 50) - 52);
			end;
		end;
--back
		LoadActor( "players" ) .. {
			BeginCommand=function(self)
				self:addx(-218);
			end;
			OnCommand=function(self) 
				self:cropleft(-0.3);
				self:cropright(1);
				self:sleep((i / 5));
				self:linear(0.2); 
				self:cropright(-0.3);
			end;
		};
		
		LoadActor( "players" ) .. {
			InitCommand=cmd(rotationy,180;);
			BeginCommand=function(self)
				self:addx(218);
			end;
			OnCommand=function(self) 
				self:cropleft(-0.3);
				self:cropright(1);
				self:sleep((i / 5));
				self:linear(0.2); 
				self:cropright(-0.3);
			end;
		};

		LoadActor( "center" ) .. {
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5));
				self:linear(0.2); 
				self:zoomy(1);
			end;
		};
	};
end;

for pn in ivalues(PlayerNumber) do
	for i = 1, mStages do

	local sStats = STATSMAN:GetPlayedStageStats( i );
	local pStageStats = sStats:GetPlayerStageStats( pn );
    
	local function GetColor()
		local pColor = "1,1,1,0";
		if pStageStats:FullComboOfScore('TapNoteScore_W1') then
			pColor = "1,1,1,1";
		elseif pStageStats:FullComboOfScore('TapNoteScore_W2') then
			pColor = "1,0.8,0,1";  
		elseif pStageStats:FullCombo() then
			pColor = "0.2,1,0.6,1";
		else
			pColor = "1,1,1,0";
		end;
		return pColor
	end;

	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(player,pn;Center);
		BeginCommand=function(self) 
			if mStages == 2 then
				self:addy(40 + ((mStages - i) * 50) - 42);
			elseif mStages == 4 then
				self:addy(-10 + ((mStages - i) * 50) - 42);
			elseif mStages == 5 then
				self:addy(-30 + ((mStages - i) * 50) - 42);
			elseif mStages == 6 then
				self:addy(-50 + ((mStages - i) * 50) - 42);
			elseif mStages == 7 then
				self:addy(-70 + ((mStages - i) * 50) - 42);
			else
				self:addy(((mStages - i) * 50) - 42);
			end;
		end;
--score 
		LoadFont( "ScreenEvaluation ScoreNumber" ) .. {
			InitCommand=cmd(zoom,0.45;diffusealpha,0);
			BeginCommand=function(self) 
				
				local pScore = pStageStats:GetScore();
				local score_length = string.len(tostring(pScore));
				local target_length = 9;
				local text = string.rep('0', clamp(target_length - score_length, 0, 9));
				local pX = 0;
				if pn == PLAYER_1 then
					pX = -240;
					self:horizalign(left);
					self:diffuse(PlayerColor(PLAYER_1));
				else
					pX = 240;
					self:horizalign(right);
					self:diffuse(PlayerColor(PLAYER_2));
				end
				self:addx(pX);

				self:settext(text .. pScore);
				if GAMESTATE:GetPlayMode() ~= "PlayMode_Rave" and GAMESTATE:GetPlayMode() ~= "PlayMode_Battle" then
					self:visible(true);
				else
					self:visible(false);
				end
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.15);
				self:linear(0.2); 
				self:zoomy(0.45);
			end;
		};
--percentscore
		LoadFont( "ScreenEvaluation percent text" ) .. {
			InitCommand=cmd(zoom,0.25;diffusealpha,0;);
			BeginCommand=function(self)
				local pPercent = pStageStats:GetPercentDancePoints();
				if pPercent == 1 then
					self:settext("100%");
				elseif pPercent == 0 then
					self:settext("0%");
				else
					self:settext(FormatPercentScore(pPercent));
				end;
				
				local pX = 0;
				if pn == PLAYER_1 then
					pX = -132;
					self:horizalign(right);
				else
					pX = 132;
					self:horizalign(left);
				end
				self:addx(pX);
				self:addy(-14);
				if GAMESTATE:GetPlayMode() ~= "PlayMode_Rave" and GAMESTATE:GetPlayMode() ~= "PlayMode_Battle" then
					self:visible(true);
				else
					self:visible(false);
				end
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:diffusealpha(1);
				self:sleep((i / 5) + 0.15);
				self:linear(0.2); 
				self:zoomy(0.25);
			end;
		};

--fullcombo
		LoadActor(THEME:GetPathG("MusicWheelItem","Song OverPart/graph_mini")) .. {
			InitCommand=cmd();
			BeginCommand=function(self)
				if pn == PLAYER_1 then
					pX = -258;
				else
					pX = 258;
				end
				self:addx(pX);
				self:diffuse(color(GetColor()));
			
				if not pStageStats:GetFailed() and pStageStats:FullCombo() and pStageStats:GetTapNoteScores('TapNoteScore_HitMine') == 0 then
					self:visible(true);
				else
					self:visible(false);
				end
			end;
			OnCommand=function(self)
				self:zoom(0);
				self:sleep((i / 5) + 0.05);
				self:linear(1);
				self:zoom(0.3);
				self:rotationy(-30);
				self:rotationx(70);
				self:rotationz(100);
				self:spin();
				self:effectmagnitude(0,0,-200);
			end;
		};
		LoadActor(THEME:GetPathG("MusicWheelItem","Song OverPart/graph_mini")) .. {
			InitCommand=cmd();
			BeginCommand=function(self)
				if pn == PLAYER_1 then
					pX = -258;
				else
					pX = 258;
				end
				self:addx(pX);
				self:diffuse(color(GetColor()));
			
				if not pStageStats:GetFailed() and pStageStats:FullCombo() and pStageStats:GetTapNoteScores('TapNoteScore_HitMine') == 0 then
					self:visible(true);
				else
					self:visible(false);
				end
			end;
			OnCommand=function(self)
				self:zoom(0);
				self:sleep((i / 5) + 0.15);
				self:linear(1);
				self:zoom(0.3);
				self:rotationy(30);
				self:rotationx(70);
				self:rotationz(100);
				self:spin();
				self:effectmagnitude(60,100,-200);
			end;
		
		};

--grade
		LoadActor("grades") .. {
			InitCommand=cmd(pause;zoom,0.35;);
			BeginCommand=function(self) 
				local pGrade = pStageStats:GetGrade();
				local state = grades[pGrade] or grades['Grade_None'];
				local pX = 0;
				if pn == PLAYER_1 then
					if pGrade == 'Grade_Tier01' then
						pX = -273;
					elseif pGrade == 'Grade_Tier02' then
						pX = -276;
					elseif pGrade == 'Grade_Tier03' then
						pX = -274;
					elseif pGrade == 'Grade_Tier04' then
						pX = -273;
					else
						pX = -270;
					end;
				else
					if pGrade == 'Grade_Tier01' then
						pX = 273;
					elseif pGrade == 'Grade_Tier02' then
						pX = 276;
					elseif pGrade == 'Grade_Tier03' then
						pX = 274;
					elseif pGrade == 'Grade_Tier04' then
						pX = 273;
					else
						pX = 270;
					end;
				end
            
				if state then
					self:visible(true);
					self:setstate(state);
				else
					self:visible(false);
				end
          
				self:addx(pX);
				self:addy(-10);
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.15);
				self:linear(0.2); 
				self:zoomy(0.35);
			end;
		};
	};
end;


for i = 1, mStages do
	local ssStats = STATSMAN:GetPlayedStageStats( i );
	
	local function ImgSize()
		local sssong = ssStats:GetPlayedSongs()[1];
		local bannerpath = sssong:GetBannerPath();
		local jacketpath = sssong:GetJacketPath();
		local imy = 40;
		if jacketpath then
			imy = 40;
		elseif bannerpath then
			imy = 30;
		else
			imy = 40;
		end;
		return imy
	end;

	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(Center);
		BeginCommand=function(self)
			if mStages == 2 then
				self:addy(40 + ((mStages - i) * 50) - 50);
			elseif mStages == 4 then
				self:addy(-10 + ((mStages - i) * 50) - 50);
			elseif mStages == 5 then
				self:addy(-30 + ((mStages - i) * 50) - 50);
			elseif mStages == 6 then
				self:addy(-50 + ((mStages - i) * 50) - 50);
			elseif mStages == 7 then
				self:addy(-70 + ((mStages - i) * 50) - 50);
			else
				self:addy(((mStages - i) * 50) - 50);
			end;
		end;
--banner
		Def.Sprite {
			BeginCommand=function(self)
				local sssong = ssStats:GetPlayedSongs()[1];
				local bannerpath = sssong:GetBannerPath();
				local jacketpath = sssong:GetJacketPath();
				self:addx(-120);
				self:horizalign(left);
				if jacketpath then
					self:Load( jacketpath );
					self:zoomtowidth(40);
				elseif bannerpath then
					self:Load( bannerpath );
					self:zoomtowidth(96);
					self:diffuserightedge(color("0,0,0,0"));
				else
					self:Load(THEME:GetPathG("Common","fallback jacket"));
					self:zoomtowidth(40);
				end;
			end;
			OnCommand=function(self) 
				self:zoomtoheight(0);
				self:sleep((i / 5) + 0.1);
				self:linear(0.2); 
				self:zoomtoheight(ImgSize());
			end;
		};
--maintitle
		LoadFont("_shared2")..{
			Name="SongMainTitle";
			InitCommand=cmd(zoom,0.65;maxwidth,290;);
			BeginCommand=function(self)
				local sssong = ssStats:GetPlayedSongs()[1];
				local sssmaint = sssong:GetDisplayMainTitle();
				self:horizalign(left);
				self:diffuse( SONGMAN:GetSongColor(sssong) );
				self:addx(-69);
				self:addy(-8);
				self:settext(sssmaint);
				if sssong:GetDisplaySubTitle() ~= "" then
					self:addy(-2);
				else
					self:addy(1);
				end;
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.125);
				self:linear(0.2); 
				self:zoomy(0.65);
			end;
		};
--subtitle
		LoadFont("_shared2")..{
			Name="SongSubTitle";
			InitCommand=cmd(zoom,0.35;maxwidth,520;);
			BeginCommand=function(self)
				local sssong = ssStats:GetPlayedSongs()[1];
				local ssssubt = sssong:GetDisplaySubTitle();
				self:horizalign(left);
				self:diffuse( SONGMAN:GetSongColor(sssong) );
				self:addx(-65);
				self:addy(-1);
				self:settext(ssssubt);
				if sssong:GetDisplaySubTitle() ~= "" then
					self:visible(true);
				else
					self:visible(false);
				end;
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.13);
				self:linear(0.2); 
				self:zoomy(0.35);
			end;
		};
--artist
		LoadFont("_shared2")..{
			Name="Artist";
			InitCommand=cmd(zoom,0.355;maxwidth,524;);
			BeginCommand=function(self)
				local sssong = ssStats:GetPlayedSongs()[1];
				local sssartistt = sssong:GetDisplayArtist();
				self:horizalign(left);
				self:diffuse( SONGMAN:GetSongColor(sssong) );
				self:addx(-69);
				self:addy(3);
				self:settext(sssartistt);
				self:addy(3);
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.135);
				self:linear(0.2); 
				self:zoomy(0.355);
			end;
		};
--stage
		Def.Sprite{
			InitCommand=cmd(zoom,0.4;);
			BeginCommand=function(self)
				local pStage = ssStats:GetStage();
				self:addx(-120);
				self:horizalign(left);
				self:addy(-23);
				self:Load(THEME:GetPathB("ScreenStageInformation","in/stageregular_effect/_label "..pStage));
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.15);
				self:linear(0.2); 
				self:zoomy(0.4);
			end;
		};
--difficulty p1
		Def.Sprite{
			InitCommand=cmd(pause;player,PLAYER_1;setstate,0;zoom,0.65;horizalign,left;);
			BeginCommand=function(self)
				local p1ssstats = ssStats:GetPlayerStageStats(PLAYER_1);
				local p1ssstep = p1ssstats:GetPlayedSteps()[1]:GetDifficulty();
				local p1statediff = DifficultyToFrame[p1ssstep];
				local pX = -241;
			
				if ssStats then
					self:Load(THEME:GetPathG("_evaluation","difficulty p1/_icons"));
					self:setstate(p1statediff);
					self:visible(true);	
				else
					self:visible(false);
				end
            
				self:addx(pX);
				self:addy(-10);
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.175);
				self:linear(0.2); 
				self:zoomy(0.65);
			end;
		};
--difficulty p2
		Def.Sprite{
			InitCommand=cmd(pause;player,PLAYER_1;setstate,0;zoom,0.65;horizalign,right;);
			BeginCommand=function(self)
				local p2ssstats = ssStats:GetPlayerStageStats(PLAYER_2);
				local p2ssstep = p2ssstats:GetPlayedSteps()[1]:GetDifficulty();
				local p2statediff = DifficultyToFrame[p2ssstep];
				local pX = 241;
			
				if ssStats then
					self:Load(THEME:GetPathG("_evaluation","difficulty p2/_icons"));
					self:setstate(p2statediff);
					self:visible(true);	
				else
					self:visible(false);
				end
            
				self:addx(pX);
				self:addy(-10);
			end;
			OnCommand=function(self) 
				self:zoomy(0);
				self:sleep((i / 5) + 0.175);
				self:linear(0.2); 
				self:zoomy(0.65);
			end;
		};
		
	};
end;

end;

return t